/****** Object:  StoredProcedure [dbo].[usp_Update_Admission_Request]    Script Date: 03/22/2012 11:04:49 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_Update_Admission_Request]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_Update_Admission_Request]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		PII
-- Create date: 24.10.2012
-- Description:	Update admission request.
-- =============================================
CREATE PROCEDURE [dbo].[usp_Update_Admission_Request] 
	@ID	INT,
	@DOMAIN_ID VARCHAR(50),
	@PATIENT_UID UNIQUEIDENTIFIER,
	@IEN VARCHAR(50),
	@ORDERED_DATE DATETIME,
	@IS_ACTIVE BIT,
	@SIGNED_DATE DATETIME,
	@RELEASED_DATE DATETIME,
	@PROVIDER_UID UNIQUEIDENTIFIER,
	@SIGNED_BY_UID UNIQUEIDENTIFIER,	
	@VISTA_SITE_UID UNIQUEIDENTIFIER,
	@HOSPITAL_LOCATION_UID UNIQUEIDENTIFIER,
	@ORDER_TEXT	VARCHAR(MAX),
	@WARD_UID UNIQUEIDENTIFIER,
	@FACILITY_LIST NVARCHAR(MAX)

AS
SET NOCOUNT ON

BEGIN

	UPDATE ADMISSION_REQ
		SET
			DOMAIN_ID = @DOMAIN_ID,
			PATIENT_UID =@PATIENT_UID,
			IEN = @IEN,
			ORDERED_DATE = @ORDERED_DATE,
			IS_ACTIVE = @IS_ACTIVE,
			SIGNED_BY_UID = @SIGNED_BY_UID, 
			SIGNED_DATE = @SIGNED_DATE, 
			RELEASED_DATE = @RELEASED_DATE, 
			PROVIDER_UID = @PROVIDER_UID,
			VISTA_SITE_UID = @VISTA_SITE_UID, 
			HOSPITAL_LOCATION_UID = @HOSPITAL_LOCATION_UID,
			ORDER_TEXT = @ORDER_TEXT,
			WARD_UID= @WARD_UID
		WHERE ID = @ID

	DELETE FROM ORDER_FACILITY WHERE ORDER_ID = @ID AND ORDER_TYPE ='ADM'
	INSERT INTO ORDER_FACILITY
		(ORDER_ID, FACILITY_UID, ORDER_TYPE)
	SELECT @ID, S.VALUE, 'ADM'
	FROM dbo.fn_Split(@FACILITY_LIST, ',') AS S

	IF @@ERROR<>0 RETURN

END
GO
